//Dustin Soodak

//Behavior 007
#include "MiscHardware.h"
void setup(){
  HardwareBegin(); 
}
int InitDegrees;
void loop(){
  SwitchPixelsToButton();
  while(!ButtonPressed());
  delay(1000);//give user a chance to remove finger so gyroscope zeroes correctly
  //this works like Behavior005:
  RotateSimple(180,200,50,1000,500);//turn approximately 180 degrees from current direction, left motor 200, right motor 50, turn timeout 1000ms, skid time to continue keeping track of direction 500ms
  //this works like Behavior006:
  RotateAccurate(0,1500);//rotate to absolute heading of 0 degrees 
}
  







  
  
  
  


/*
//behavior 002
//Read degrees and angular velocity:
#include "Navigation.h"
#include "MiscHardware.h"//for simple timer functions RestartTimer() & GetTime()
void setup(){
  Serial.begin(38400);
  delay(1000);//make sure not moving robot when NavigationBegin() since it also zeroes the sensors
  NavigationBegin();//initialize and start navigation
  RestartTimer();  
}
int PrintDelay=200;
void loop(){
  SimpleGyroNavigation();//just does gyroscope (not accelerometer)
  if(GetTime()>PrintDelay){
    if(GyroFifoOverflow)//happens if SimpleGyroNavigation() not called often enough (in which case readings will not be accurate)
      Serial.print("overflow ");
    Serial.print("degrees: ");
    Serial.print(GetDegrees(),DEC);
    Serial.print(", degrees per secpnd: ");
    Serial.println(GetDegreesPerSecond(),DEC);
    RestartTimer(); 
  }
}
*/

/*
//behavior 003
//raw gyro data example:
#include "Navigation.h"
#include "MiscHardware.h"//for simple timer functions RestartTimer() & GetTime()
void setup(){
  Serial.begin(38400);
  delay(1000);//make sure not moving robot when NavigationBegin() since it also zeroes the sensors
  NavigationBegin();//initialize and start navigation
  RestartTimer();  
}
int PrintDelay=200;
int data[3];
void loop(){
  if(GyroBufferSize()>0){
    GyroGetAxes(data);
  } 
  if(GetTime()>PrintDelay){
    Serial.print(data[0]);
    Serial.print(" ");
    Serial.print(data[1]);
    Serial.print(" ");
    Serial.print(data[2]);
    Serial.println(" ");
    RestartTimer();
  }
}
*/

/*
behavior 004
//Bump detection with gyroscope
#include "Navigation.h"
#include "MiscHardware.h"//for simple timer functions RestartTimer() & GetTime()
void setup(){
  Serial.begin(38400);
  delay(1000);//make sure not moving robot when NavigationBegin() since it also zeroes the sensors
  NavigationBegin();//initialize and start navigation
  RestartTimer();  
}
int PrintDelay=200;
int BumpLevel=10;
int PrintBump=0;
int dpsX,dpsY,dpsZ;//to store degrees and degress per second
void loop(){
  SimpleGyroNavigation();  
  dpsX=GetDegreesPerSecondX();
  dpsY=GetDegreesPerSecondY();
  dpsZ=GetDegreesPerSecondZ();
  if(abs(dpsX)>BumpLevel || abs(dpsY)>BumpLevel  || abs(dpsZ)>BumpLevel)
    PrintBump=1;
  if(GetTime()>PrintDelay || PrintBump){
    if(GyroFifoOverflow)//happens if SimpleGyroNavigation() not called often enough
      Serial.print("overflow ");
    Serial.print("dpsX: ");
    Serial.print(dpsX,DEC);
    Serial.print(", dpsY: ");
    Serial.print(dpsY,DEC);
    Serial.print(", dpsZ: ");
    Serial.print(dpsZ,DEC);
    if(PrintBump){
      Serial.print(" bumped! ");      
    }
    Serial.println();
    PrintBump=0;
    RestartTimer(); 
  }
}
*/



/*
//behavior 005
//Rotate with gyroscope
//Assumes that direction it is pointing at startup is zero degrees
//Type desired heading, then it will turn until it thinks it will
//skid (with motors off) to approximately that direction. 
#include "Navigation.h"
#include "MiscHardware.h"//for HardwareBegin(),SwitchSerialToMotors(),SwitchMotorsToSerial(),RestartTimer(),GetTime(), 
void setup(){
  HardwareBegin();
  //Serial.begin(38400);//removed since HardwareBegin() includes all of the other initialization functions
  Serial.println("type # of degrees followed by ENTER, then press button to turn.");
  delay(1000);//make sure not moving robot when NavigationBegin() since it also zeroes the sensors
  NavigationBegin();//initialize and start navigation
  RestartTimer();
}
int PrintDelay=200;
int Turn=0;
int deg;//to store degrees and degress per second
String NumString = "";
int ch;
int TargetDegrees,DegrMotorStarted=0,DegrMotorStopped=0,DegrPredict, DegrMotorSkid, DPSAtSkid;
int dir;
void loop(){
  SimpleGyroNavigation();
  deg=GetDegrees();
  if(Serial.available() > 0){
    ch = Serial.read();    
    if (isDigit(ch) || ch=='-'){
      NumString += (char)ch;  
    }
    if(ch=='\n'){      
      TargetDegrees=NumString.toInt();  
      DegrMotorStarted=0;DegrMotorStopped=0;//just so we know if we haven't tried turning since new setting
      NumString="";
    }
  }//end if(Serial.available() > 0)
  
  if(GetTime()>PrintDelay){
    if(GyroFifoOverflow)//happens if SimpleGyroNavigation() not called often enough
      Serial.print("overflow ");   
    Serial.print("Started ");
    Serial.print(DegrMotorStarted,DEC);
    Serial.print(" stopped ");
    Serial.print(DegrMotorStopped,DEC);
    Serial.print(" (");
    Serial.print(DPSAtSkid,DEC);//degrees per second
    Serial.print(" dps), skidded to ");
    Serial.print(DegrMotorSkid,DEC);    
    Serial.print(", target ");//in absolute degrees, not relative to start position for this rotation
    Serial.print(TargetDegrees,DEC);

    Serial.print(", current: "); 
    Serial.println(deg,DEC);
    
    RestartTimer(); 
  }//end if(GetTime()>PrintDelay)
  
  SwitchPixelsToButton();
  if(ButtonPressed()){
    delay(10);//debounce button
    while(ButtonPressed())
      SimpleGyroNavigation();
    RestartTimer();
    while(GetTime()<500){//to let user get finger away
      SimpleGyroNavigation();
    } 
    DegrMotorStarted=GetDegrees();
    SwitchButtonToPixels();
    SetPixelRGB(5,0,50,0);SetPixelRGB(6,0,50,0);RefreshPixels();
    SwitchSerialToMotors();
    if(TargetDegrees>DegrMotorStarted){
      Motors(150,-150);
      dir=1;
    }
    else if(TargetDegrees<DegrMotorStarted){
      Motors(-150,150); 
      dir=-1;
    }    
    RestartTimer();
    while(GetTime()<3000){//3000 = 3 second timeout
      SimpleGyroNavigation();
      deg=GetDegrees();   
      DegrPredict=deg+GetDegreesToStop(); //DegrPredict=degr+GyroDegreesToStopFromRaw(rate);//(((float)(-rate))*2000/32768)*0.1029-(24);        
      if(dir>=0?(DegrPredict>=TargetDegrees):(DegrPredict<=TargetDegrees)){ 
        DPSAtSkid=GetDegreesPerSecond();
        break; 
      }
    }
    Motors(0,0);
    DegrMotorStopped=GetDegrees();   
    SwitchButtonToPixels();
    SetPixelRGB(5,50,0,0);SetPixelRGB(6,50,0,0);RefreshPixels();
    RestartTimer();
    while(GetTime()<500){//to let it skid to a halt
      SimpleGyroNavigation();
    } 
    DegrMotorSkid=GetDegrees();
    SetPixelRGB(5,0,0,0);SetPixelRGB(6,0,0,0);RefreshPixels();   
    SwitchMotorsToSerial();  
    RestartTimer();   
  }//end if(ButtonPressed()
  
}
*/

/*
//Behavior 006
//maintain heading
#include "MiscHardware.h"
#include "Navigation.h"
void setup(){
  HardwareBegin();
  SwitchButtonToPixels();
  SetPixelRGB(2,0,0,0);SetPixelRGB(3,0,0,0);RefreshPixels();
  SwitchSerialToMotors();
  Motors(0,0);  
  SwitchPixelsToButton();
  while(!ButtonPressed());
  delay(1000);//give you time to stop touching reset button so gyro zeroes correctly
  SwitchButtonToPixels();
  SetPixelRGB(2,0,0,M_Bright);SetPixelRGB(3,0,0,M_Bright);RefreshPixels();
  delay(200);
  NavigationBegin();
  ResumeNavigation();
  RestartTimer();
}
int degr,skid,motor;
char WasCorrectDirection=0;
void loop(){
  SimpleGyroNavigation();
  degr=GetDegrees();
  skid=GetDegreesToStop();
  if(abs(degr)<2){
    Motors(0,0);  
    if(!WasCorrectDirection){
      SetPixelRGB(2,0,0,0);SetPixelRGB(3,0,0,0);RefreshPixels(); 
      WasCorrectDirection=1;
    }   
    SwitchMotorsToSerial();
    if(GetTime()>200){      
      if(GyroFifoOverflow)//happens if SimpleGyroNavigation() not called often enough
        Serial.print("overflow ");
      Serial.print("degrees: ");
      Serial.print(GetDegrees(),DEC);
      Serial.print(", degrees per secpnd: ");
      Serial.println(GetDegreesPerSecond(),DEC);
      RestartTimer(); 
      SwitchSerialToMotors();
    }
  }
  else{       
    SwitchSerialToMotors();   
    motor=30+abs(degr+skid);
    if(motor>200)
      motor=200;      
    if(degr+skid>0)
      Motors(-motor,motor); 
    else
      Motors(motor,-motor); 
    if(WasCorrectDirection){      
      SetPixelRGB(2,0,0,M_Bright);SetPixelRGB(3,0,0,M_Bright);RefreshPixels();  
      WasCorrectDirection=0;
    }
  }
}//end loop()

*/









/*
//print received IR data
#include "MiscHardware.h"
void setup(){
  HardwareBegin(); 
  RxIRRestart();
}
int i;
void loop(){

  if(IsIRDone()){
      RxIRStop();
      for(i=0;i<IRNumOfBytes;i++){
        Serial.println(((unsigned char)IRBytes[i]),HEX);
      }
      RxIRRestart();
  }
}
*/

/*
//Look at amplitude and direction of acceleration using SimpleNavigation()
#include "MiscHardware.h"
#include "Navigation.h"
#include <math.h>
void setup(){
  HardwareBegin();
}
int accelx,accely,accelz,dir;
void loop(){
  NavigationBegin();  
  RestartTimer();
  while(1){
    SimpleNavigation();
    accelx=GetAccelerationX();
    accely=GetAccelerationY();
    accelz=GetAccelerationZ();
    dir=90-atan2(accely,accelx)*180/3.14159;
    if(GetTime()>200){
      Serial.print(accelx,DEC);
      Serial.print(" ");
      Serial.print(accely,DEC);
      Serial.print(" ");
      Serial.print(accelz,DEC);
      Serial.print(" dir ");
      Serial.println(dir,DEC);
      RestartTimer(); 
    }
  }//end while(1)
}//end loop()
*/













/*

//Video template
#include "MiscHardware.h"
#include "Navigation.h"
#include <math.h>
void BackAwayFunction(char c){
  Motors(-200,-200);
  SwitchButtonToPixels();
  SetPixelRGB(5,50,0,0);SetPixelRGB(6,50,0,0);RefreshPixels();
  delay(200);
  SetPixelRGB(5,0,0,0);SetPixelRGB(6,0,0,0);RefreshPixels();
  SwitchPixelsToButton();
  Motors(0,0);
}
void setup(){
  HardwareBegin();
  SwitchButtonToPixels();
  PlayChirp(1000, 50);
  SetPixelRGB(5,0,0,50);SetPixelRGB(6,0,0,50);RefreshPixels();
  delay(100);
  SetPixelRGB(5,0,0,0);SetPixelRGB(6,0,0,0);RefreshPixels();
  PlayChirp(1000, 0);
  
  
}
//extern void MoveStraightWithOptions(int Direction, int Speed, int Distance, int MaxExpectedRunTime, int MaxExpectedSkidTime, 
//                                    void (*EdgeFunction)(char), char Wiggle);//50 is about medium wiggle
int heading,currentheading;
int bumpdir,slidedir;
extern int32_t AverGyroVelocity;
int i,n,offset,degr,skid,motor,prevleft,prevright;
int accelx,accely,accelz;
int32_t largenum;
char edge,mode=0;
void loop(){
  SwitchPixelsToButton();
  RestartTimer();
  SwitchMotorsToSerial();
  RxIRRestart();
  while(1){
    if(IsIRDone()){
      RxIRStop();
      for(i=0;i<IRNumOfBytes;i++){
        Serial.println(((unsigned char)IRBytes[i]),HEX);
      }
      if(IRBytes[2]==0x45 && IRBytes[3]==0xBA){//power//if(IRBytes[2]==0x44 && IRBytes[3]==0xBB)//test//
        IRBytes[2]=0;IRBytes[3]=0;
        break;
      }
      else{
        RxIRRestart();
        SwitchPixelsToButton();
      }
      if(ButtonPressed()){
        delay(1000);
        break; 
      }
    }//end if(IsIRDone())
  }//end while(1) wait for robot or IR button



 //9th shot:   (#include <math.h>) reacting to being poked
  SwitchButtonToPixels();
  SetPixelRGB(4,200,0,0);RefreshPixels();
  delay(100);
  SetPixelRGB(4,0,0,0);RefreshPixels();
  NavigationBegin(); 
  RestartTimer();
  while(1){
    //SimpleNavigation();//only shows the latest acceleration, which is often in different direction than initial bump
    //accelx=GetAccelerationX();
    //accely=GetAccelerationY();
    //instead: work with current raw values:
    n=AccelBufferSize();    
    if(n){
      AccelGetAxes(AccelAcceleration);
      AccelAcceleration[0]=AccelAcceleration[0]-AccelZeroes[0];//x-axis raw
      AccelAcceleration[1]=AccelAcceleration[1]-AccelZeroes[1];//y-axis raw
    }
    accelx=-AccelAcceleration[0];//still raw x, but facing correct direction
    accely=-AccelAcceleration[1];//still raw y, but facing correct direction
    //if(GetTime()>200){
    //  Serial.print(accelx,DEC);Serial.print(" ");Serial.println(accely,DEC);
    //  RestartTimer(); 
    //}
    if(abs(accelx)>4000 || abs(accely)>4000){
      bumpdir=180+(90-atan2(accely,accelx)*180/3.14159);
      heading=GetDegrees()+bumpdir;  
      RestartTimer();
      SwitchButtonToPixels();
      SetPixelRGB(4,200,0,0);RefreshPixels();    
      while(GetTime()<100){//wait till is is most likely skidding skidding
        SimpleGyroNavigation();//look at gyroscope as it turns
      }
      AccelGetAxes(AccelAcceleration);
      AccelAcceleration[0]=AccelAcceleration[0]-AccelZeroes[0];//x-axis raw
      AccelAcceleration[1]=AccelAcceleration[1]-AccelZeroes[1];//y-axis raw
      largenum=((int32_t)accelx)*(-AccelAcceleration[0])+((int32_t)accely)*(-AccelAcceleration[1]);//dot product of old & new {xaccel,yaccel}
      if(largenum>0){//largenum is now = cosine of angle between new and old multiplied by their amplitudes
        bumpdir-=180;//if skid direction within 180 degrees of bump direction, then "bump" was probably actually part of skid
        //or can put code here to check again in 20ms, just in case this is just an artifact of vibration        
      }
      
      //remove this for faster response
      while(GetTime()<400){
        SimpleGyroNavigation();//look at gyroscope as it turns
      }
      ZeroNavigationSensors();//assuming that it will be stopped by this point, so safe to use this function
      //end remove this for faster response
      
      Serial.print(accelx,DEC);Serial.print(" ");Serial.println(accely,DEC);
      SetPixelRGB(4,0,0,0);RefreshPixels();
      currentheading=GetDegrees();
      degr=heading-currentheading;
      //the following makes sure it turns the least distance (in degrees) to point at the source of the disturbance
      if(degr>=0){
        if(degr>=360)
          degr-=360;
        if(degr>180)
          degr=-(360-degr);
      }
      else{
        if(degr<=-360)
          degr+=360;
        if(degr<-180){
          degr=(360-(-degr)); 
        }
      }
      SwitchMotorsToSerial();
      Serial.print(" reldir ");Serial.print(bumpdir,DEC);
      Serial.print(" absdir ");Serial.print(heading,DEC);
      Serial.print(" now facing ");Serial.print(currentheading,DEC);
      Serial.print(" turn ");Serial.print(degr,DEC);
      Serial.print(" (");Serial.print(largenum,DEC);Serial.println(")");
      //behavior  (note: currentheading+degr is the heading of the offending poke)
      
      //comment out all but one of the following:
             
      
      //don't touch me         
      RotateAccurate(currentheading+degr,2000);
      delay(200);
      SetPixelRGB(5,50,0,0);SetPixelRGB(6,50,0,0);RefreshPixels();
      Motors(200,200);
      PlayAnger();  
      for(i=0;i<3;i++){    
        Motors(-200,-200);
        SetPixelRGB(5,50,50,0);SetPixelRGB(6,50,50,0);RefreshPixels();
        PlayChirp(NOTE_C6,100);
        delay(50);
        Motors(200,200);
        SetPixelRGB(5,50,0,0);SetPixelRGB(6,50,0,0);RefreshPixels();
        PlayChirp(NOTE_CS6,100);
        delay(50);
      }
      Motors(-200,-200);
      PlayAnger();
      Motors(0,0);
      delay(300);//to let any movement or rocking go away
      SetPixelRGB(5,0,0,0);SetPixelRGB(6,0,0,0);RefreshPixels();
      SwitchMotorsToSerial();
      //end don't touch me
      
      
      
      //piss pants and run away (remove "remove this for faster response" code above to make this better)
      if(degr>0)
        degr-=180;
      else{
        degr+=180; 
      }  
      SetPixelRGB(2,100,100,0);SetPixelRGB(3,100,100,0);RefreshPixels();      
      MoveWithOptions(currentheading+degr, 200, 900, 1000, 500, 0,0); 
      SetAllPixelsRGB(0,0,0);RefreshPixels();
      SwitchMotorsToSerial();
      //end piss pants and run away
      
      
      //I'll run the first 2 times...
      if(mode<2){
        if(degr>0)
          degr-=180;
        else{
          degr+=180; 
        } 
        RotateAccurate(currentheading+degr,2000);
        delay(200);
        SetPixelRGB(5,50,0,0);SetPixelRGB(6,50,0,0);RefreshPixels();
        Motors(200,200);
        PlayAnger(); 
        Motors(0,0);
        delay(300);//to let any movement or rocking go away
        SetPixelRGB(5,0,0,0);SetPixelRGB(6,0,0,0);RefreshPixels();
        SwitchMotorsToSerial();
        mode++;
      }
      else{
        RotateAccurate(currentheading+degr,2000);
        delay(200);
        SetPixelRGB(5,50,0,0);SetPixelRGB(6,50,0,0);RefreshPixels();
        Motors(200,200);
        PlayAnger();  
        for(i=0;i<4;i++){    
          Motors(-200,-200);
          SetPixelRGB(5,50,50,0);SetPixelRGB(6,50,50,0);RefreshPixels();
          PlayChirp(NOTE_C6,100);
          delay(50);
          Motors(200,200);
          SetPixelRGB(5,50,0,0);SetPixelRGB(6,50,0,0);RefreshPixels();
          PlayChirp(NOTE_CS6,100);
          delay(70);
        }
        Motors(-200,-200);
        PlayAnger();
        Motors(0,0);
        delay(300);//to let any movement or rocking go away
        SetPixelRGB(5,0,0,0);SetPixelRGB(6,0,0,0);RefreshPixels();
        SwitchMotorsToSerial();
        mode=0;
      }//end if(mode<2)
      //end I'll run the first 2 times...
      
      
      
    }//end if(abs(accelx)>4000 || abs(accely)>4000)
  }//end while(1)
  
  
}//end loop()

*/

  /*
  //first shot: come in, turn 180 degrees, then head out.
  SwitchButtonToPixels();
  SetPixelRGB(5,0,200,0);SetPixelRGB(6,0,200,0);RefreshPixels();
  heading=GetDegrees();
  MoveWithOptions(heading, 150, 300, 3000, 500, 0,0); 
  SetPixelRGB(5,0,200,0);SetPixelRGB(6,0,200,0);RefreshPixels();
  RotateSimple(heading+180-GetDegrees(), 150, -150, 1000, 500);//MoveWithOptions(heading+180, 0, 600, 2000, 100, BackAwayFunction,0);
  SetPixelRGB(5,0,0,0);SetPixelRGB(6,0,0,0);RefreshPixels();
  MoveWithOptions(heading+180, 150, 300, 3000, 500, 0,50);
  */
      
  /*
  //second  shot: spin a bunch, then shoot off
  SwitchButtonToPixels();
  SetPixelRGB(5,0,200,0);SetPixelRGB(6,0,200,0);RefreshPixels();
  RotateSimple(360*5, 200, -200, 1000, 500);//MoveWithOptions(heading+180, 0, 600, 2000, 100, BackAwayFunction,0);
  SetPixelRGB(5,0,0,0);SetPixelRGB(6,0,0,0);RefreshPixels();
  MoveWithOptions(GetDegrees()-360, 150, 300, 3000, 500, 0,50);
  */

/*
  //third shot: square but using sloppy turn function
  offset=0;
  ZeroNavigation();
  SwitchButtonToPixels();
  SetPixelRGB(2,0,0,M_Bright);SetPixelRGB(3,0,0,M_Bright);SetPixelRGB(5,0,H_Bright,0);SetPixelRGB(6,0,H_Bright,0);RefreshPixels();
  for(i=0;i<16;i++){
    MoveWithOptions(offset, 150, 90, 3000, 250, 0,0);
    offset+=90;
    RotateSimple(offset-GetDegrees(), 150, -150, 1000, 250);
  }
  SetAllPixelsRGB(0,0,0);RefreshPixels();
*/


/*
  //fourth shot: "introducing..." move into scene, then turn off then slowly turn on lights
  offset=0;
  SwitchButtonToPixels();
  SetPixelRGB(2,0,0,M_Bright);SetPixelRGB(3,0,0,M_Bright);SetPixelRGB(5,0,H_Bright,0);SetPixelRGB(6,0,H_Bright,0);RefreshPixels();
  MoveWithOptions(offset, 150, 300, 1000, 0, 0,50);//modified so flashing front lights
  SetAllPixelsRGB(0,0,0);RefreshPixels();
  delay(200);
  for(i=0;i<150;i++){
    delay(20);
     SetPixelRGB(2,0,0,i);SetPixelRGB(3,0,0,i);SetPixelRGB(5,i,0,i);SetPixelRGB(6,i,0,i);RefreshPixels();
  }    
  delay(1000);
  SetAllPixelsRGB(0,0,0);RefreshPixels();
*/


/*
 //fifth shot: slowly turn on LEDs, then 180 degree turn an shoot off (nice with 2 at same time)
 offset=0;
  SwitchButtonToPixels();
  ZeroNavigation();
  SetAllPixelsRGB(0,0,0);RefreshPixels();
  for(i=0;i<150;i++){
    delay(20);
     SetPixelRGB(2,0,0,i);SetPixelRGB(3,0,0,i);SetPixelRGB(5,i,i/3,i/3);SetPixelRGB(6,i,i/3,i/3);RefreshPixels();
  }
  MoveWithOptions(180, 150, 2000, 1300, 0, 0,0);
  delay(200);
  SetAllPixelsRGB(0,0,0);RefreshPixels();

*/



/*
//behavior 006
//Sixth shot: maintain direction with gyro (
  SwitchButtonToPixels();
  SetPixelRGB(2,0,0,M_Bright);SetPixelRGB(3,0,0,M_Bright);RefreshPixels();
  NavigationBegin();
  ResumeNavigation();
  SwitchSerialToMotors();
  while(1){  
    SimpleGyroNavigation();
    degr=GetDegrees();
    skid=GetDegreesToStop();
    if(abs(degr)<2){
      Motors(0,0);
      SwitchMotorsToSerial();
      if(GetTime()>200){      
        if(GyroFifoOverflow)//happens if SimpleGyroNavigation() not called often enough
          Serial.print("overflow ");
        Serial.print("degrees: ");
        Serial.print(GetDegrees(),DEC);
        Serial.print(", degrees per secpnd: ");
        Serial.println(GetDegreesPerSecond(),DEC);
        RestartTimer(); 
        SwitchSerialToMotors();
      }
    }
    else{   
      SwitchSerialToMotors();   
      motor=30+abs(degr+skid);
      if(motor>200)
        motor=200;      
      if(degr+skid>0)
        Motors(-motor,motor); 
      else
        Motors(motor,-motor); 
    }    
  }
*/



/*
//seventh shot: go towards the light
SwitchSerialToMotors();
  SwitchButtonToPixels();
  SetPixelRGB(2,100,30,30);SetPixelRGB(3,80,80,0);RefreshPixels();
  ExploreExample(70, 60*5, 500);//modified with no timeout, and IR & edge detection off, and going right into AddictedToLight mode.
  
*/

/*
 //eighth shot: follow line
  offset=40;
  SwitchSerialToMotors();
  Motors(100,120);//Serial.print("straight");//
  ResetLookAtEdge();
  SwitchButtonToPixels();
  while(1){
    edge=LookForEdge();
    delay(10);
    if(edge==1){
      Motors(100+offset,120-offset);//Serial.print("right   ");//
      SetPixelRGB(5,0,50,0);SetPixelRGB(6,0,0,0);RefreshPixels();
      prevright=RightEdgeSensorAverage;
      while(RightEdgeSensorValue<prevright){//LookForEdge() just goes on momentarily (errs in favor of not being stuck on)
        LookForEdge();
      }
    }
    else if(edge==2){
      Motors(100-offset,120+offset);//Serial.print("left   ");//
      SetPixelRGB(5,0,0,0);SetPixelRGB(6,0,50,0);RefreshPixels();
      prevleft=LeftEdgeSensorAverage;
      while(LeftEdgeSensorValue<prevleft){//LookForEdge() just goes on momentarily (errs in favor of not being stuck on)
        LookForEdge();
      }
    }
    else if(edge==3){
      SetPixelRGB(5,0,50,0);SetPixelRGB(6,0,50,0);RefreshPixels(); 
    }
    else{
      Motors(100,120);//Serial.print("straight");//
      SetPixelRGB(5,0,0,0);SetPixelRGB(6,0,0,0);RefreshPixels();
    }
  }//end while(1)  
*/



/*
  //9th shot:   (#include <math.h>) reacting to being poked
  SwitchButtonToPixels();
  SetPixelRGB(4,200,0,0);RefreshPixels();
  delay(100);
  SetPixelRGB(4,0,0,0);RefreshPixels();
  NavigationBegin(); 
  RestartTimer();
  while(1){
    //SimpleNavigation();//only shows the latest acceleration, which is often in different direction than initial bump
    //accelx=GetAccelerationX();
    //accely=GetAccelerationY();
    //instead: work with current raw values:
    n=AccelBufferSize();    
    if(n){
      AccelGetAxes(AccelAcceleration);
      AccelAcceleration[0]=AccelAcceleration[0]-AccelZeroes[0];//x-axis raw
      AccelAcceleration[1]=AccelAcceleration[1]-AccelZeroes[1];//y-axis raw
    }
    accelx=-AccelAcceleration[0];//still raw x, but facing correct direction
    accely=-AccelAcceleration[1];//still raw y, but facing correct direction
    //if(GetTime()>200){
    //  Serial.print(accelx,DEC);Serial.print(" ");Serial.println(accely,DEC);
    //  RestartTimer(); 
    //}
    if(abs(accelx)>4000 || abs(accely)>4000){
      bumpdir=180+(90-atan2(accely,accelx)*180/3.14159);
      heading=GetDegrees()+bumpdir;  
      RestartTimer();
      SwitchButtonToPixels();
      SetPixelRGB(4,200,0,0);RefreshPixels();    
      while(GetTime()<100){//wait till is is most likely skidding skidding
        SimpleGyroNavigation();//look at gyroscope as it turns
      }
      AccelGetAxes(AccelAcceleration);
      AccelAcceleration[0]=AccelAcceleration[0]-AccelZeroes[0];//x-axis raw
      AccelAcceleration[1]=AccelAcceleration[1]-AccelZeroes[1];//y-axis raw
      largenum=((int32_t)accelx)*(-AccelAcceleration[0])+((int32_t)accely)*(-AccelAcceleration[1]);//dot product of old & new {xaccel,yaccel}
      if(largenum>0){//largenum is now = cosine of angle between new and old multiplied by their amplitudes
        bumpdir-=180;//if skid direction within 180 degrees of bump direction, then "bump" was probably actually part of skid
        //or can put code here to check again in 20ms, just in case this is just an artifact of vibration        
      }
      
      //remove this for faster response
      while(GetTime()<400){
        SimpleGyroNavigation();//look at gyroscope as it turns
      }
      ZeroNavigationSensors();//assuming that it will be stopped by this point, so safe to use this function
      //end remove this for faster response
      
      Serial.print(accelx,DEC);Serial.print(" ");Serial.println(accely,DEC);
      SetPixelRGB(4,0,0,0);RefreshPixels();
      currentheading=GetDegrees();
      degr=heading-currentheading;
      //the following makes sure it turns the least distance (in degrees) to point at the source of the disturbance
      if(degr>=0){
        if(degr>=360)
          degr-=360;
        if(degr>180)
          degr=-(360-degr);
      }
      else{
        if(degr<=-360)
          degr+=360;
        if(degr<-180){
          degr=(360-(-degr)); 
        }
      }
      SwitchMotorsToSerial();
      Serial.print(" reldir ");Serial.print(bumpdir,DEC);
      Serial.print(" absdir ");Serial.print(heading,DEC);
      Serial.print(" now facing ");Serial.print(currentheading,DEC);
      Serial.print(" turn ");Serial.print(degr,DEC);
      Serial.print(" (");Serial.print(largenum,DEC);Serial.println(")");
      //behavior  (note: currentheading+degr is the heading of the offending poke)
      
      //comment out all but one of the following:
             
      
      //don't touch me         
      RotateAccurate(currentheading+degr,2000);
      delay(200);
      SetPixelRGB(5,50,0,0);SetPixelRGB(6,50,0,0);RefreshPixels();
      Motors(200,200);
      PlayAnger();  
      for(i=0;i<3;i++){    
        Motors(-200,-200);
        SetPixelRGB(5,50,50,0);SetPixelRGB(6,50,50,0);RefreshPixels();
        PlayChirp(NOTE_C6,100);
        delay(50);
        Motors(200,200);
        SetPixelRGB(5,50,0,0);SetPixelRGB(6,50,0,0);RefreshPixels();
        PlayChirp(NOTE_CS6,100);
        delay(50);
      }
      Motors(-200,-200);
      PlayAnger();
      Motors(0,0);
      delay(300);//to let any movement or rocking go away
      SetPixelRGB(5,0,0,0);SetPixelRGB(6,0,0,0);RefreshPixels();
      SwitchMotorsToSerial();
      //end don't touch me
      
      
      
      //piss pants and run away (remove "remove this for faster response" code above to make this better)
      if(degr>0)
        degr-=180;
      else{
        degr+=180; 
      }  
      SetPixelRGB(2,100,100,0);SetPixelRGB(3,100,100,0);RefreshPixels();      
      MoveWithOptions(currentheading+degr, 200, 900, 1000, 500, 0,0); 
      SetAllPixelsRGB(0,0,0);RefreshPixels();
      SwitchMotorsToSerial();
      //end piss pants and run away
      
      
      //I'll run the first 2 times...
      if(mode<2){
        if(degr>0)
          degr-=180;
        else{
          degr+=180; 
        } 
        RotateAccurate(currentheading+degr,2000);
        delay(200);
        SetPixelRGB(5,50,0,0);SetPixelRGB(6,50,0,0);RefreshPixels();
        Motors(200,200);
        PlayAnger(); 
        Motors(0,0);
        delay(300);//to let any movement or rocking go away
        SetPixelRGB(5,0,0,0);SetPixelRGB(6,0,0,0);RefreshPixels();
        SwitchMotorsToSerial();
        mode++;
      }
      else{
        RotateAccurate(currentheading+degr,2000);
        delay(200);
        SetPixelRGB(5,50,0,0);SetPixelRGB(6,50,0,0);RefreshPixels();
        Motors(200,200);
        PlayAnger();  
        for(i=0;i<4;i++){    
          Motors(-200,-200);
          SetPixelRGB(5,50,50,0);SetPixelRGB(6,50,50,0);RefreshPixels();
          PlayChirp(NOTE_C6,100);
          delay(50);
          Motors(200,200);
          SetPixelRGB(5,50,0,0);SetPixelRGB(6,50,0,0);RefreshPixels();
          PlayChirp(NOTE_CS6,100);
          delay(70);
        }
        Motors(-200,-200);
        PlayAnger();
        Motors(0,0);
        delay(300);//to let any movement or rocking go away
        SetPixelRGB(5,0,0,0);SetPixelRGB(6,0,0,0);RefreshPixels();
        SwitchMotorsToSerial();
        mode=0;
      }//end if(mode<2)
      //end I'll run the first 2 times...
            
      
    }//end if(abs(accelx)>4000 || abs(accely)>4000)
  }//end while(1)  
*/



